/* TextIt: binary to text converter, by Daniel Guerrero 1998.
 * Purpose: convert binary files in to a list of C compiler readable
 * 16-bit integers.
 * Created with Lcc-Win32 version 2.4 (November 26, 1998)
 * ------------------------------------------------------------------
 * This is public domain software. Absolutly no warranty.
 * ------------------------------------------------------------------
 * PORTABILITY ISSUES:
 * The program relies in the startup code to expand wildcards.
 * In other compilers, a wildcard expansion routine should be
 * added.
 */


#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <io.h>
#include <direct.h>

typedef int BOOL;
#define TRUE (0 == 0)
#define FALSE (!TRUE)

BOOL fPromptReplace = TRUE;
BOOL fSameDir = FALSE;

/* this function is needed because _cgets() and _cscanf() */
/* do very nasty things in Win32! */

static int GetConsoleString (char * lpszDest, int nMax)
{
	int nPos = 0;
	int nReadChar;
	BOOL fFinished;

	/* output the default string */
	cputs (lpszDest);
	nPos = strlen (lpszDest);
	/* parse the keyboard input */
	fFinished = FALSE;
	while (!fFinished)
	{
		nReadChar = getch();

		switch (nReadChar)
		{
			case '\0':
			case 0xE0:
				/* multy char control key, skip next */
				getch();
				break;
			case '\b':
				if (nPos > 0)
				{
					nPos--;
					cputs ("\b \b");
				}
				break;
			case '\r':
			case '\n':
				lpszDest[nPos]='\0';
				fFinished = TRUE;
				break;
			default :
				if ( (nPos < nMax) && (!iscntrl(nReadChar)) )
				{
					lpszDest[nPos]=nReadChar;
					nPos++;
					putch(nReadChar);
				}
		} /* switch */
	} /* while */

	/* clear the input buffer */
	while (_kbhit()) getch();

	return nPos;
}

static void ShowHelp (void)
{
	_cprintf (
			"Syntax: TextIt [/k] [/r] <input file 1> [<input file 2> ...]\n"
			"\n"
			"<Input file x> : the name of the input file(s) (wildcards allowed).\n"
			"     The output file is assumed to have the same name as the input file with\n"
		  	"     .TXT extension.\n"
			"/k : (optional) keep output files in the same directory as input files (by\n"
			"     default, output files will be created in the current working directory).\n"
			"/r : (optional) replace output files without prompting.\n"
			);
}

static BOOL IsFlag (char *str, char *flag)
{
	int i = 0;
	int j = 0;

	/* skip white spaces (possible in win32) */
	while (str[i] == ' ') i++;

	/* chech for the flag mark */
	if ((str[i] == '/') || (str[i] == '-'))
	{
		/* skip the mark */
		i++;

		/* skip white spaces */
		while (str[i] == ' ') i++;

		/* compare with the flag */
		while (flag[j] != '\0')
		{
			if (str[i] != flag[j]) break;
			i++;
			j++;
		}

		return (str[i] == flag[j]);
	}
	return FALSE;
}

BOOL ParseFlag (char * lpszFlag)
{
	if ( (IsFlag (lpszFlag, "k")) || (IsFlag (lpszFlag, "K")) )
	{
		fSameDir = !fSameDir;
		return TRUE;
	}
	else
	{
		if ( (IsFlag (lpszFlag, "r")) || (IsFlag (lpszFlag, "R")) )
		{
			fPromptReplace = !fPromptReplace;
			return TRUE;
		}
	}
	return FALSE;
}

static void GuessOutputName (char *lpszInputName, char *lpszOutputName)
{
	char szInDrive[_MAX_DRIVE];
	char szInDir[_MAX_DIR];
	char szInFname[_MAX_FNAME];
	char szInExt[_MAX_EXT];
	char szCwd[_MAX_PATH];

	_splitpath (lpszInputName, szInDrive, szInDir, szInFname, szInExt);
	if (fSameDir)
		_makepath (lpszOutputName, szInDrive, szInDir, szInFname, "TXT");
	else
	{
		if (_getcwd(szCwd, _MAX_PATH) == NULL)
		{
			lpszOutputName[0] = '\0';
			return;
		}

		sprintf (lpszOutputName,"%s\\%s.TXT",szCwd, szInFname);
	}
}

static BOOL WantReplace (char *lpszOutputName)
{
	int nSelection;
	BOOL fValidSelection;
	BOOL fResult;

	_cprintf ("WARNING: \"%s\" already exists. Replace? [Y]es/[N]o: N\b",lpszOutputName);

	fValidSelection = FALSE;
	do
	{
		nSelection = _getch();
		switch (nSelection)
		{
			case 'Y':
			case 'y':
				fValidSelection = TRUE;
				fResult = TRUE;
				break;
			case 'N':
			case 'n':
			case '\r':
			case '\n':
				fValidSelection = TRUE;
				fResult = FALSE;
				ungetch (nSelection);
				break;
			case 0x00:
			case 0xE0:
				_getch();
				break;
		} /* switch */
	}while (!fValidSelection);
	/* flush the input buffer */
	while (_kbhit()) _getch();
	_cprintf ("%c\n",nSelection);

	return fResult;
}

static void QueryOutName (char *lpszOutputName)
{
	do
	{
		_cprintf ("\rEnter output file name: ");
	} while (GetConsoleString (lpszOutputName, _MAX_PATH) == 0);
	_cprintf ("\n");
}

static BOOL ExistsFile (char * lpszFileName)
{
	return (_access (lpszFileName, 0) == 0);
}

static BOOL ProcessFile (char *lpszInputName, char *lpszOutputName)
{
	FILE *lpInFile, *lpOutFile;
	BOOL fSuccess = FALSE;
	int nColumn;
	short sVal;
	size_t FreadCount;

	lpInFile = fopen (lpszInputName, "rb");
	if (lpInFile != NULL)
	{
		lpOutFile = fopen (lpszOutputName, "wt");
		if (lpOutFile != NULL)
		{
			/* read first value sepparatedly */
			nColumn = 0;
			sVal = 0;
			FreadCount = fread (&sVal, 1, 2, lpInFile);
			if (FreadCount > 0)
			{
				fprintf (lpOutFile, "0x%04hX", sVal);
				nColumn++;
				FreadCount = fread (&sVal, 1, 2, lpInFile);
			}
			/* Process the rest of the file */
			while ( (FreadCount > 0) && (!ferror(lpInFile)) )
			{
				if (nColumn >= 10)
				{
					fprintf (lpOutFile, ",\n0x%04hX", sVal);
					nColumn = 1;
				}
				else
				{
					fprintf (lpOutFile, ",0x%04hX", sVal);
					nColumn++;
				}
				sVal = 0;
				FreadCount = fread (&sVal, 1, 2, lpInFile);
			} /* while */
			fprintf (lpOutFile, "\n"); // LRC needs the file to end with a new line

			fSuccess = !ferror (lpInFile);
			/* close the output file */
			fclose (lpOutFile);
		} /* if (lpOutFile != NULL) */
		/* close the input file */
		fclose (lpInFile);
	} /* if (lpInfile != NULL) */

	return fSuccess;
}

void main (int nNumArg, char * lpszArg[])
{
	int nFiles = 0;
	char szOutName[_MAX_PATH];
	int i;
	BOOL fValidOutName;


	/* say hello ... */
	_cprintf ("TextIt, binary to text converter.\n");
    _cprintf ("By Daniel Guerrero Miralles 1998. Public Domain.\n\n");

	/* parse the arguments */
	if (nNumArg == 1)
	{
		ShowHelp();
		return;
	}

	i = 1;
	while (i < nNumArg)
	{
		if (!ParseFlag(lpszArg[i]))
		{
			if (ExistsFile (lpszArg[i]))
			{
				GuessOutputName(lpszArg[i], szOutName);
				if ((ExistsFile (szOutName)) && fPromptReplace)
				{
					fValidOutName = FALSE;
					do
					{
						if (!WantReplace (szOutName))
						{
							QueryOutName (szOutName);
							fValidOutName = !ExistsFile (szOutName);
						}
						else
						{
							fValidOutName = TRUE;
						}
					} while (!fValidOutName);
				} /* if ((FileExists (szOutName)) && fPromptReplace) */
				printf ("Converting %s to %s...",lpszArg[i], szOutName);
				if (ProcessFile (lpszArg[i], szOutName))
				{
					printf ("OK\n");
					nFiles ++;
				}
				else
				{
					printf ("ERROR\n");
				}
			} /* if (FileExists (lpszArg[i])) */
			else
			{
				printf ("WARNING: file \"%s\" not found, skipping...\n", lpszArg[i]);
			} /* if (!FileExists (lpszArg[i])) */
		} /* if (!ParseFlag(lpszArg[i])) */
		i++;
	} /* while (i < nNumArg) */

	if (nFiles == 1)
		printf ("1 file processed.\n");
	else
		printf ("%i files processed.\n", nFiles);
}
