/////////////////////////////////////////////////////////////////////////
// Program na prevod binarnich souboru na textove: bin2txt             //
//                                                                     //
// Syntax: bin2txt [options] input output                              //
//                                                                     //
// options:   -x	:hex output                                        //
//            -bn	:where n=1,2,4 is size of "record" in bytes        //
//            -s	:signed "records"                                  //
//            -cn   :add each n "record" in output CR+LF               //
//            -on   :16bit offset n bytes from start of file           //
//            -an	:add ASCII separator n between data in output      //
//  (c) Josef Planeta 1998                                             //
/////////////////////////////////////////////////////////////////////////

#include 	<stdio.h>

//globalni promenne
FILE *i_file;				//input file
FILE *o_file;  				//output file

int hex=1;					//hexadecimalni vystup
int bytes=2;				//delka 2 bajty
int sig=0;					//znamenkove
int crlf=8;					//kazdych x hodnot proloz cr+lf
int offset=0;				//zacni o offset od zacatku file
int separator=44;			//ASCII separator za data ve vystupu
unsigned char in_file[15];	//8+3+\0+
unsigned char out_file[15];	//8+3+\0+


unsigned int f,g,h;		//pomocna
char firstf=0;		//flag:prvni file=input uz byl zpracovan(1), 0=nebyl
char firstsep=0;	//flag:prvni separator byl zaznamenan (=1), aby nebyla carka na konci
int counter;		//flag-citac cr+lf
unsigned int pom;	//pomocna UNSIGNED
signed int spom;	//pomocna SIGNED



main(int argc, char *argv[] )
{
//bez argumentu
if (argc == 1) goto syntax;

//printf("Argc= %d\n",argc);
//projedeme vsechny parametry, preskocime volani samotneho exe
for(f=1; f<argc; f++)
	{
	//HELP
	if ((*(argv[f]) == '-') && ((*(argv[f]+1) == '?') || (*(argv[f]+1) == 'h') || (*(argv[f]+1) == 'H')))
		goto syntax;

	//HEX
	if ((*(argv[f]) == '-') && ( *(argv[f]+1) == 'd' || *(argv[f]+1) == 'D'))
		hex=0;

	//SIG
	if ((*(argv[f]) == '-') && ( *(argv[f]+1) == 's' || *(argv[f]+1) == 'S'))
		sig=1;

	//BYTES
	if ((*(argv[f]) == '-') && ( *(argv[f]+1) == 'b' || *(argv[f]+1) == 'B'))
		sscanf( (argv[f]+2), "%d", &bytes );

	//crlf
	if ((*(argv[f]) == '-') && ( *(argv[f]+1) == 'c' || *(argv[f]+1) == 'C'))
		sscanf( (argv[f]+2), "%d", &crlf );

	//separator
	if ((*(argv[f]) == '-') && ( *(argv[f]+1) == 'a' || *(argv[f]+1) == 'A'))
		sscanf( (argv[f]+2), "%d", &separator );

	//offset
	if ((*(argv[f]) == '-') && ( *(argv[f]+1) == 'o' || *(argv[f]+1) == 'O'))
		sscanf( (argv[f]+2), "%u", &offset );



	//outputfile - musi byt v tomto poradi, aby neprobehlo oboji v jednom behu!!
	if ((*(argv[f]) != '-') && (firstf == 1))
		{
		sscanf( (argv[f]), "%s", &out_file );
		firstf=2;
		}


	//inputfile
	if ((*(argv[f]) != '-') && (firstf == 0))
		{
		sscanf( (argv[f]), "%s", &in_file );
		firstf=1;
		}


	}

//co je potreba ohlidat je bytes:
if ((bytes != 1) && (bytes != 2) && (bytes != 4))
	goto syntax;

//jeste zkontrolujeme, pokud zadal oba files:
if (firstf != 2)
	goto syntax;


//// PARAMETRY PREDANY, TED OTEVREME SOUBORY ////

if (( i_file = fopen( in_file, "rb" )) == NULL )
      {
      printf( "ERROR: Cannot open input file!\n" );
      getchar();
	  return (0);
      }


if (( o_file = fopen( out_file, "wt" )) == NULL )
      {
      printf( "ERROR: Cannot open output file!\n" );
      getchar();
	  return (0);
      }

//pokud je offset, tak ho proved:
if ((fseek(i_file, (long)offset, SEEK_SET)) != 0 )		//0=OK
	goto syntax;										//toto ale nejak nefunguje!!


// SOUBORY OTEVRENY, TED SE PROVEDE KONVERZE

counter=crlf;

while(1)
{
pom=0;

for(g=0; g < bytes; g++)
	{
	f=fgetc(i_file);
	if ((f==EOF) && (g != 0))
		{										//neco zbylo nezpracovano
		putc('\n', o_file);						//posledni \n
		printf("%d bytes remaind\n", g );
		getchar();
		return (0);
		}
	if ((f==EOF) && (g == 0))
		{
		putc('\n', o_file);						//posledni \n
		return (0);								//vse vyslo
		}

	f = f << (8*g);
	pom = (unsigned int) pom | (unsigned int) f;

	}	//pom ted drzi to, co se nacetlo

if (sig == 1)				//pokud ma byt vystup znamenkovy
	{
	if (bytes==1)			//vystup 1 bajt
		spom = (signed char) pom;
	else
		spom = (signed int) pom;
	}

//ZAPISEME NA VYSTUP

if (hex == 1)				//hex vystup
	{
	if (firstsep == 1)		//flag je nahozen po prvnim zapisu separatoru
		putc(separator, o_file);

	//CR+LF
	if (firstsep == 1)
		{
		counter-=1;
		if (counter == 0)		//pridej CR+LF
			{
			putc('\n', o_file);
			counter=crlf;
			}

		if (counter == -1)		//crlf=0 => zakaz CR+LF
			counter+=1;			//zase inc, tim to srovname
		}
		firstsep = 1;

		//VLASTNI ZAPIS:
		switch(bytes)
		{
		case 1:
				fprintf(o_file, "%#04x",pom);
				break;
		case 2:
				fprintf(o_file, "%#06x",pom);
				break;

		case 4:
				fprintf(o_file, "%#010x",pom);
				break;

		}//switch
	}//hex=1

else				//dekadicky vystup
	{
	if (firstsep == 1)		//flag je nahozen po prvnim zapisu separatoru
		putc(separator, o_file);

	//CR+LF
	if (firstsep == 1)
		{
		counter-=1;
		if (counter == 0)		//pridej CR+LF
			{
			putc('\n', o_file);
			counter=crlf;
			}

		if (counter == -1)		//crlf=0 => zakaz CR+LF
			counter+=1;			//zase inc, tim to srovname
		}
		firstsep = 1;

		//VLASTNI ZAPIS:
		switch(bytes)
		{
		case 1:
			if (sig==0)				//neznamenkovy
				fprintf(o_file, "%u",(unsigned char)pom);
			else					//znamenkovy
				fprintf(o_file, "%d",(signed char)spom);

			break;

		case 2:
			if (sig==0)				//neznamenkovy
				fprintf(o_file, "%u",(unsigned int)pom);
			else					//znamenkovy
				fprintf(o_file, "%d",(unsigned int)pom-65536);

			break;

		case 4:
			if (sig==0)				//neznamenkovy
				fprintf(o_file, "%u",(unsigned int)pom);
			else					//znamenkovy
				fprintf(o_file, "%d",(signed int)spom);

			break;

		}//switch

	}				//dekad. zapis


}	//while





fclose(i_file);
fclose(o_file);

//skonci
return (0);


syntax:

fcloseall();
printf("\n");
printf("       Bin2Txt is small utility for dump binary files to txt file \n");
printf("       ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ \n\n");
printf("Usage:   bin2txt  [options]  inputfile outputfile \n");
printf("\n");
printf("Options: -an	:add ASCII separator n between data in output [Default=44 (,)]\n");
printf("         -bn    :where n=1,2,4 is size of integer record in bytes [Default=2]\n");
printf("         -cn    :add each n records in output CR+LF, 0=OFF [Default=8]\n");
printf("         -d     :dec output [Default=OFF]\n");
printf("         -on    :16bit offset n bytes from start of file [Default=0]\n");
printf("         -s     :signed integer input data [Default=OFF]\n");
printf("\n");
printf("Example: bin2txt -b1 -c0 -o44 sound.wav dump.txt  \n");
printf("\n\n");
printf("              (c) Josef Planeta 1998, Czech Republic, Brno \n");
printf("              Written in LCC-Win32, the BEST free C compiler\n");
printf("\n\n\n");
printf("               !!!  F R E E W A R E  -  E N J O Y   I T  !!! \n");
printf("\n(Enter)");
getchar();

return (0);
}

